/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.DefaultInfoImpl;
import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.catalog.types.StatisticsImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.dictionary.CheckConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.DependencyDescriptor;
import org.apache.derby.iapi.sql.dictionary.GenericDescriptorList;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatisticsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.catalog.DDColumnDependableFinder;
import org.apache.derby.impl.sql.execute.BasicSortObserver;
import org.apache.derby.impl.sql.execute.CardinalityCounter;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.CreateConstraintConstantAction;
import org.apache.derby.impl.sql.execute.DDLConstantAction;
import org.apache.derby.impl.sql.execute.DDLSingleTableConstantAction;
import org.apache.derby.impl.sql.execute.DropConstraintConstantAction;
import org.apache.derby.impl.sql.execute.DropIndexConstantAction;
import org.apache.derby.impl.sql.execute.DropTriggerConstantAction;
import org.apache.derby.impl.sql.execute.IndexColumnOrder;

class AlterTableConstantAction
extends DDLSingleTableConstantAction
implements RowLocationRetRowSource {
    protected SchemaDescriptor sd;
    protected String tableName;
    protected UUID schemaId;
    protected int tableType;
    protected long tableConglomerateId;
    protected ColumnInfo[] columnInfo;
    protected ConstraintConstantAction[] constraintActions;
    protected char lockGranularity;
    private boolean compressTable;
    private boolean sequential;
    private int behavior;
    private boolean doneScan;
    private boolean[] needToDropSort;
    private boolean[] validRow;
    private int bulkFetchSize = 16;
    private int currentCompressRow;
    private int numIndexes;
    private int rowCount;
    private long estimatedRowCount;
    private long[] indexConglomerateNumbers;
    private long[] sortIds;
    private FormatableBitSet indexedCols;
    private ConglomerateController compressHeapCC;
    private ExecIndexRow[] indexRows;
    private ExecRow[] baseRow;
    private ExecRow currentRow;
    private GroupFetchScanController compressHeapGSC;
    private IndexRowGenerator[] compressIRGs;
    private DataValueDescriptor[][] baseRowArray;
    private RowLocation[] compressRL;
    private SortController[] sorters;
    private int columnPosition;
    private ColumnOrdering[][] ordering;
    private TableDescriptor td;
    private boolean truncateTable;
    private LanguageConnectionContext lcc;
    private DataDictionary dd;
    private DependencyManager dm;
    private TransactionController tc;
    private Activation activation;

    public String toString() {
        if (this.truncateTable) {
            return "TRUNCATE TABLE " + this.tableName;
        }
        return "ALTER TABLE " + this.tableName;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        dataDictionary.startWriting(languageConnectionContext);
        if (this.tableConglomerateId == 0L) {
            this.td = dataDictionary.getTableDescriptor(this.tableId);
            if (this.td == null) {
                throw StandardException.newException("X0X05.S", this.tableName);
            }
            this.tableConglomerateId = this.td.getHeapConglomerateId();
        }
        this.lockTableForDDL(transactionController, this.tableConglomerateId, true);
        this.td = dataDictionary.getTableDescriptor(this.tableId);
        if (this.td == null) {
            throw StandardException.newException("X0X05.S", this.tableName);
        }
        if (this.truncateTable) {
            dependencyManager.invalidateFor(this.td, 42, languageConnectionContext);
        } else {
            dependencyManager.invalidateFor(this.td, 12, languageConnectionContext);
        }
        this.execGuts(activation);
    }

    public void execGuts(Activation activation) throws StandardException {
        Object object;
        Object object2;
        int n;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        activation.setDDLTableDescriptor(this.td);
        if (this.sd == null) {
            this.sd = DDLConstantAction.getAndCheckSchemaDescriptor(dataDictionary, this.schemaId, "ALTER TABLE");
        }
        if (this.truncateTable) {
            dependencyManager.invalidateFor(this.td, 42, languageConnectionContext);
        } else {
            dependencyManager.invalidateFor(this.td, 12, languageConnectionContext);
        }
        if (this.columnInfo != null) {
            n = 0;
            while (n < this.columnInfo.length) {
                if (this.columnInfo[n].action == 0 && !this.columnInfo[n].dataType.isNullable() && this.columnInfo[n].defaultInfo == null && this.columnInfo[n].autoincInc == 0L) {
                    bl = true;
                }
                ++n;
            }
            if (bl) {
                n2 = this.getSemiRowCount(transactionController);
                if (n2 > 0) {
                    throw StandardException.newException("X0Y57.S", this.td.getQualifiedName());
                }
                bl2 = true;
            }
            n = 0;
            while (n < this.columnInfo.length) {
                object2 = new ColumnDescriptorList();
                if (this.columnInfo[n].action == 0) {
                    this.addNewColumnToTable(activation, n);
                } else if (this.columnInfo[n].action == 1) {
                    this.modifyColumnDefault(activation, n);
                } else if (this.columnInfo[n].action == 3) {
                    this.modifyColumnType(activation, n);
                } else if (this.columnInfo[n].action == 4) {
                    this.modifyColumnConstraint(activation, this.columnInfo[n].name, true);
                } else if (this.columnInfo[n].action == 5) {
                    String[] stringArray;
                    if (!bl2) {
                        bl2 = true;
                        n2 = this.getSemiRowCount(transactionController);
                    }
                    if (this.validateNotNullConstraint(stringArray = new String[]{this.columnInfo[n].name}, (boolean[])(object = (Object)new boolean[1]), n2, languageConnectionContext, "X0Y80.S")) {
                        this.modifyColumnConstraint(activation, this.columnInfo[n].name, false);
                    }
                } else if (this.columnInfo[n].action == 2) {
                    this.dropColumnFromTable(activation, n);
                }
                ++n;
            }
        }
        if (this.constraintActions != null) {
            n = 0;
            while (n < this.constraintActions.length) {
                object2 = this.constraintActions[n];
                if (object2 instanceof CreateConstraintConstantAction) {
                    int n3 = ((ConstraintConstantAction)object2).getConstraintType();
                    switch (n3) {
                        case 2: {
                            object = dataDictionary.getConstraintDescriptors(this.td);
                            if (((ConstraintDescriptorList)object).getPrimaryKey() != null) {
                                throw StandardException.newException("X0Y58.S", this.td.getQualifiedName());
                            }
                            if (bl2) break;
                            bl2 = true;
                            n2 = this.getSemiRowCount(transactionController);
                            break;
                        }
                        case 4: {
                            if (!bl2) {
                                bl2 = true;
                                n2 = this.getSemiRowCount(transactionController);
                            }
                            if (n2 <= 0) break;
                            ConstraintConstantAction.validateConstraint(((ConstraintConstantAction)object2).getConstraintName(), ((CreateConstraintConstantAction)object2).getConstraintText(), this.td, languageConnectionContext, true);
                            break;
                        }
                    }
                }
                this.constraintActions[n].executeConstantAction(activation);
                ++n;
            }
        }
        if (this.lockGranularity != '\u0000') {
            this.td.setLockGranularity(this.lockGranularity);
            dataDictionary.updateLockGranularity(this.td, this.sd, this.lockGranularity, transactionController);
        }
        if (this.compressTable) {
            this.compressTable(activation);
        }
        if (this.truncateTable) {
            this.truncateTable(activation);
        }
    }

    private void addNewColumnToTable(Activation activation, int n) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnInfo[n].name);
        int n2 = this.td.getMaxColumnID() + n;
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        if (columnDescriptor != null) {
            throw StandardException.newException("X0Y32.S", columnDescriptor.getDescriptorType(), (Object)this.columnInfo[n].name, (Object)this.td.getDescriptorType(), (Object)this.td.getQualifiedName());
        }
        DataValueDescriptor dataValueDescriptor = this.columnInfo[n].defaultValue != null ? this.columnInfo[n].defaultValue : this.columnInfo[n].dataType.getNull();
        transactionController.addColumnToConglomerate(this.td.getHeapConglomerateId(), n2, dataValueDescriptor);
        UUID uUID = this.columnInfo[n].newDefaultUUID;
        if (this.columnInfo[n].defaultInfo != null && uUID == null) {
            uUID = dataDictionary.getUUIDFactory().createUUID();
        }
        columnDescriptor = new ColumnDescriptor(this.columnInfo[n].name, n2 + 1, this.columnInfo[n].dataType, this.columnInfo[n].defaultValue, this.columnInfo[n].defaultInfo, this.td, uUID, this.columnInfo[n].autoincStart, this.columnInfo[n].autoincInc, this.columnInfo[n].autoincInc != 0L);
        dataDictionary.addDescriptor(columnDescriptor, this.td, 2, false, transactionController);
        this.td.getColumnDescriptorList().add(columnDescriptor);
        if (columnDescriptor.isAutoincrement()) {
            this.updateNewAutoincrementColumn(activation, this.columnInfo[n].name, this.columnInfo[n].autoincStart, this.columnInfo[n].autoincInc);
        }
        if (columnDescriptor.hasNonNullDefault()) {
            this.updateNewColumnToDefault(activation, this.columnInfo[n].name, this.columnInfo[n].defaultInfo.getDefaultText(), languageConnectionContext);
            DefaultDescriptor defaultDescriptor = new DefaultDescriptor(dataDictionary, uUID, this.td.getUUID(), n2 + 1);
            ProviderInfo[] providerInfoArray = ((DefaultInfoImpl)this.columnInfo[n].defaultInfo).getProviderInfo();
            int n3 = providerInfoArray == null ? 0 : providerInfoArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Provider provider = null;
                try {
                    provider = (Provider)providerInfoArray[n4].getDependableFinder().getDependable(providerInfoArray[n4].getObjectId());
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                dependencyManager.addDependency(defaultDescriptor, provider, languageConnectionContext.getContextManager());
                ++n4;
            }
        }
    }

    private void dropColumnFromTable(Activation activation, int n) throws StandardException {
        int n2;
        Object object;
        ConstraintDescriptor constraintDescriptor;
        int n3;
        int n4;
        Serializable serializable;
        Object object2;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnInfo[n].name);
        if (columnDescriptor == null) {
            throw StandardException.newException("42X14", this.columnInfo[n].name, (Object)this.td.getQualifiedName());
        }
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        ColumnDescriptorList columnDescriptorList = this.td.getColumnDescriptorList();
        int n5 = columnDescriptorList.size();
        if (n5 == 1) {
            throw StandardException.newException("X0Y25.S", dependencyManager.getActionString(37), (Object)("THE *LAST* COLUMN " + this.columnInfo[n].name), (Object)"TABLE", (Object)this.td.getQualifiedName());
        }
        this.columnPosition = columnDescriptor.getPosition();
        boolean bl = this.behavior == 0;
        FormatableBitSet formatableBitSet = new FormatableBitSet(n5 + 1);
        formatableBitSet.set(this.columnPosition);
        this.td.setReferencedColumnMap(formatableBitSet);
        dependencyManager.invalidateFor(this.td, bl ? 38 : 37, languageConnectionContext);
        if (columnDescriptor.getDefaultInfo() != null) {
            object2 = columnDescriptor.getDefaultDescriptor(dataDictionary);
            dependencyManager.clearDependencies(languageConnectionContext, (Dependent)object2);
        }
        object2 = dataDictionary.getTriggerDescriptors(this.td);
        Enumeration enumeration = ((GenericDescriptorList)object2).elements();
        while (enumeration.hasMoreElements()) {
            serializable = (TriggerDescriptor)enumeration.nextElement();
            int[] nArray = ((TriggerDescriptor)serializable).getReferencedCols();
            if (nArray == null) continue;
            n4 = nArray.length;
            n3 = 0;
            int n6 = 0;
            while (n6 < n4) {
                if (nArray[n6] > this.columnPosition) {
                    n3 = 1;
                } else if (nArray[n6] == this.columnPosition) {
                    if (bl) {
                        DropTriggerConstantAction.dropTriggerDescriptor(languageConnectionContext, dependencyManager, dataDictionary, transactionController, (TriggerDescriptor)serializable, activation);
                        activation.addWarning(StandardException.newWarning("01502", ((TriggerDescriptor)serializable).getName(), this.td.getName()));
                        break;
                    }
                    throw StandardException.newException("X0Y25.S", dependencyManager.getActionString(37), (Object)this.columnInfo[n].name, (Object)"TRIGGER", (Object)((TriggerDescriptor)serializable).getName());
                }
                ++n6;
            }
            if (n6 != n4 || n3 == 0) continue;
            dataDictionary.dropTriggerDescriptor((TriggerDescriptor)serializable, transactionController);
            n6 = 0;
            while (n6 < n4) {
                if (nArray[n6] > this.columnPosition) {
                    int n7 = n6;
                    nArray[n7] = nArray[n7] - 1;
                }
                ++n6;
            }
            dataDictionary.addDescriptor((TupleDescriptor)((Object)serializable), this.sd, 13, false, transactionController);
        }
        serializable = dataDictionary.getConstraintDescriptors(this.td);
        int n8 = ((ArrayList)serializable).size();
        n4 = 0;
        ConstraintDescriptor[] constraintDescriptorArray = new ConstraintDescriptor[n8];
        n3 = n8 - 1;
        while (n3 >= 0) {
            constraintDescriptor = ((ConstraintDescriptorList)serializable).elementAt(n3);
            object = constraintDescriptor.getReferencedColumns();
            n2 = ((int[])object).length;
            boolean bl2 = false;
            int n9 = 0;
            while (n9 < n2) {
                if (object[n9] > this.columnPosition) {
                    bl2 = true;
                }
                if (object[n9] == this.columnPosition) break;
                ++n9;
            }
            if (n9 == n2) {
                if (constraintDescriptor instanceof CheckConstraintDescriptor && bl2) {
                    dataDictionary.dropConstraintDescriptor(this.td, constraintDescriptor, transactionController);
                    n9 = 0;
                    while (n9 < n2) {
                        if (object[n9] > this.columnPosition) {
                            Object object3 = object;
                            int n10 = n9;
                            object3[n10] = object3[n10] - true;
                        }
                        ++n9;
                    }
                    ((CheckConstraintDescriptor)constraintDescriptor).setReferencedColumnsDescriptor(new ReferencedColumnsDescriptorImpl((int[])object));
                    dataDictionary.addConstraintDescriptor(constraintDescriptor, transactionController);
                }
            } else {
                if (!(bl || n2 <= 1 && constraintDescriptor.getConstraintType() != 2)) {
                    throw StandardException.newException("X0Y25.S", dependencyManager.getActionString(37), (Object)this.columnInfo[n].name, (Object)"CONSTRAINT", (Object)constraintDescriptor.getConstraintName());
                }
                if (constraintDescriptor instanceof ReferencedKeyConstraintDescriptor) {
                    constraintDescriptorArray[n4++] = constraintDescriptor;
                } else {
                    dependencyManager.invalidateFor(constraintDescriptor, 19, languageConnectionContext);
                    DropConstraintConstantAction.dropConstraintAndIndex(dependencyManager, this.td, dataDictionary, constraintDescriptor, transactionController, activation, true);
                    activation.addWarning(StandardException.newWarning("01500", constraintDescriptor.getConstraintName(), this.td.getName()));
                }
            }
            --n3;
        }
        n3 = n4 - 1;
        while (n3 >= 0) {
            constraintDescriptor = constraintDescriptorArray[n3];
            DropConstraintConstantAction.dropConstraintAndIndex(dependencyManager, this.td, dataDictionary, constraintDescriptor, transactionController, activation, false);
            activation.addWarning(StandardException.newWarning("01500", constraintDescriptor.getConstraintName(), this.td.getName()));
            if (bl) {
                object = dataDictionary.getForeignKeys(constraintDescriptor.getUUID());
                n2 = 0;
                while (n2 < ((ArrayList)object).size()) {
                    ConstraintDescriptor constraintDescriptor2 = ((ConstraintDescriptorList)object).elementAt(n2);
                    dependencyManager.invalidateFor(constraintDescriptor2, 19, languageConnectionContext);
                    DropConstraintConstantAction.dropConstraintAndIndex(dependencyManager, constraintDescriptor2.getTableDescriptor(), dataDictionary, constraintDescriptor2, transactionController, activation, true);
                    activation.addWarning(StandardException.newWarning("01500", constraintDescriptor2.getConstraintName(), constraintDescriptor2.getTableDescriptor().getName()));
                    ++n2;
                }
            }
            dependencyManager.invalidateFor(constraintDescriptor, 19, languageConnectionContext);
            dependencyManager.clearDependencies(languageConnectionContext, constraintDescriptor);
            --n3;
        }
        this.compressTable(activation);
        dataDictionary.dropColumnDescriptor(this.td.getUUID(), this.columnInfo[n].name, transactionController);
        TupleDescriptor[] tupleDescriptorArray = new ColumnDescriptor[n5 - columnDescriptor.getPosition()];
        int n11 = columnDescriptor.getPosition();
        int n12 = 0;
        while (n11 < n5) {
            ColumnDescriptor columnDescriptor2 = columnDescriptorList.elementAt(n11);
            dataDictionary.dropColumnDescriptor(this.td.getUUID(), columnDescriptor2.getColumnName(), transactionController);
            columnDescriptor2.setPosition(n11);
            tupleDescriptorArray[n12] = columnDescriptor2;
            ++n11;
            ++n12;
        }
        dataDictionary.addDescriptorArray(tupleDescriptorArray, this.td, 2, false, transactionController);
        List list = dataDictionary.getProvidersDescriptorList(this.td.getObjectID().toString());
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            DependencyDescriptor dependencyDescriptor = (DependencyDescriptor)listIterator.next();
            DependableFinder dependableFinder = dependencyDescriptor.getProviderFinder();
            if (!(dependableFinder instanceof DDColumnDependableFinder)) continue;
            DDColumnDependableFinder dDColumnDependableFinder = (DDColumnDependableFinder)dependableFinder;
            FormatableBitSet formatableBitSet2 = new FormatableBitSet(dDColumnDependableFinder.getColumnBitMap());
            FormatableBitSet formatableBitSet3 = new FormatableBitSet(formatableBitSet2);
            formatableBitSet3.clear();
            int n13 = formatableBitSet2.getLength();
            int n14 = 0;
            while (n14 < n13) {
                if (n14 < this.columnPosition && formatableBitSet2.isSet(n14)) {
                    formatableBitSet3.set(n14);
                }
                if (n14 > this.columnPosition && formatableBitSet2.isSet(n14)) {
                    formatableBitSet3.set(n14 - 1);
                }
                ++n14;
            }
            if (formatableBitSet3.equals(formatableBitSet2)) continue;
            dataDictionary.dropStoredDependency(dependencyDescriptor, transactionController);
            dDColumnDependableFinder.setColumnBitMap(formatableBitSet3.getByteArray());
            dataDictionary.addDescriptor(dependencyDescriptor, null, 6, true, transactionController);
        }
    }

    private void modifyColumnType(Activation activation, int n) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnInfo[n].name);
        ColumnDescriptor columnDescriptor2 = null;
        columnDescriptor2 = new ColumnDescriptor(this.columnInfo[n].name, columnDescriptor.getPosition(), this.columnInfo[n].dataType, columnDescriptor.getDefaultValue(), columnDescriptor.getDefaultInfo(), this.td, columnDescriptor.getDefaultUUID(), this.columnInfo[n].autoincStart, this.columnInfo[n].autoincInc, this.columnInfo[n].autoincInc != 0L);
        dataDictionary.dropColumnDescriptor(this.td.getUUID(), this.columnInfo[n].name, transactionController);
        dataDictionary.addDescriptor(columnDescriptor2, this.td, 2, false, transactionController);
    }

    private void modifyColumnConstraint(Activation activation, String string, boolean bl) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(string);
        ColumnDescriptor columnDescriptor2 = null;
        DataTypeDescriptor dataTypeDescriptor = columnDescriptor.getType();
        dataTypeDescriptor.setNullability(bl);
        columnDescriptor2 = new ColumnDescriptor(string, columnDescriptor.getPosition(), dataTypeDescriptor, columnDescriptor.getDefaultValue(), columnDescriptor.getDefaultInfo(), this.td, columnDescriptor.getDefaultUUID(), columnDescriptor.getAutoincStart(), columnDescriptor.getAutoincInc(), columnDescriptor.getAutoincInc() != 0L);
        dataDictionary.dropColumnDescriptor(this.td.getUUID(), string, transactionController);
        dataDictionary.addDescriptor(columnDescriptor2, this.td, 2, false, transactionController);
    }

    private void modifyColumnDefault(Activation activation, int n) throws StandardException {
        Object object;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnInfo[n].name);
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        int n2 = columnDescriptor.getPosition();
        if (columnDescriptor.hasNonNullDefault()) {
            object = new DefaultDescriptor(dataDictionary, this.columnInfo[n].oldDefaultUUID, this.td.getUUID(), n2);
            dependencyManager.invalidateFor((Provider)object, 31, languageConnectionContext);
            dependencyManager.clearDependencies(languageConnectionContext, (Dependent)object);
        }
        object = this.columnInfo[n].newDefaultUUID;
        if (this.columnInfo[n].defaultInfo != null && object == null) {
            object = dataDictionary.getUUIDFactory().createUUID();
        }
        columnDescriptor = new ColumnDescriptor(this.columnInfo[n].name, n2, this.columnInfo[n].dataType, this.columnInfo[n].defaultValue, this.columnInfo[n].defaultInfo, this.td, (UUID)object, this.columnInfo[n].autoincStart, this.columnInfo[n].autoincInc, this.columnInfo[n].autoincInc != 0L);
        dataDictionary.dropColumnDescriptor(this.td.getUUID(), this.columnInfo[n].name, transactionController);
        dataDictionary.addDescriptor(columnDescriptor, this.td, 2, false, transactionController);
        if (this.columnInfo[n].autoincInc != 0L) {
            long l = this.getColumnMax(activation, this.td, this.columnInfo[n].name, this.columnInfo[n].autoincInc, this.columnInfo[n].autoincStart);
            dataDictionary.setAutoincrementValue(transactionController, this.td.getUUID(), this.columnInfo[n].name, l, true);
        }
        if (columnDescriptor.hasNonNullDefault()) {
            DefaultDescriptor defaultDescriptor = new DefaultDescriptor(dataDictionary, (UUID)object, this.td.getUUID(), n2);
            ProviderInfo[] providerInfoArray = ((DefaultInfoImpl)this.columnInfo[n].defaultInfo).getProviderInfo();
            int n3 = providerInfoArray == null ? 0 : providerInfoArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Provider provider = null;
                try {
                    provider = (Provider)providerInfoArray[n4].getDependableFinder().getDependable(providerInfoArray[n4].getObjectId());
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                dependencyManager.addDependency(defaultDescriptor, provider, languageConnectionContext.getContextManager());
                ++n4;
            }
        }
    }

    private void compressTable(Activation activation) throws StandardException {
        Properties properties = new Properties();
        this.lcc = activation.getLanguageConnectionContext();
        this.dd = this.lcc.getDataDictionary();
        this.dm = this.dd.getDependencyManager();
        this.tc = this.lcc.getTransactionExecute();
        this.activation = activation;
        ExecRow execRow = this.td.getEmptyExecRow(this.lcc.getContextManager());
        this.compressHeapCC = this.tc.openConglomerate(this.td.getHeapConglomerateId(), false, 4, 7, 5);
        this.dm.invalidateFor(this.td, 33, this.lcc);
        RowLocation rowLocation = this.compressHeapCC.newRowLocationTemplate();
        this.compressHeapCC.getInternalTablePropertySet(properties);
        this.compressHeapCC.close();
        this.compressHeapCC = null;
        this.baseRow = new ExecRow[this.bulkFetchSize];
        this.baseRowArray = new DataValueDescriptor[this.bulkFetchSize][];
        this.validRow = new boolean[this.bulkFetchSize];
        this.getAffectedIndexes(activation);
        this.compressRL = new RowLocation[this.bulkFetchSize];
        this.indexRows = new ExecIndexRow[this.numIndexes];
        if (!this.compressTable) {
            ExecRow execRow2 = activation.getExecutionFactory().getValueRow(execRow.nColumns() - 1);
            int n = 0;
            while (n < execRow2.nColumns()) {
                execRow2.setColumn(n + 1, n < this.columnPosition - 1 ? execRow.getColumn(n + 1) : execRow.getColumn(n + 1 + 1));
                ++n;
            }
            execRow = execRow2;
        }
        this.setUpAllSorts(execRow, rowLocation);
        this.openBulkFetchScan(this.td.getHeapConglomerateId());
        this.estimatedRowCount = this.compressHeapGSC.getEstimatedRowCount();
        int n = 0;
        while (n < this.bulkFetchSize) {
            this.baseRow[n] = this.td.getEmptyExecRow(this.lcc.getContextManager());
            this.baseRowArray[n] = this.baseRow[n].getRowArray();
            this.compressRL[n] = this.compressHeapGSC.newRowLocationTemplate();
            ++n;
        }
        long l = this.tc.createAndLoadConglomerate("heap", execRow.getRowArray(), null, properties, 0, this, null);
        this.closeBulkFetchScan();
        ScanController scanController = this.tc.openScan(l, false, 4, 7, 5, null, null, 0, null, null, 0);
        scanController.setEstimatedRowCount(this.rowCount);
        scanController.close();
        scanController = null;
        this.dd.startWriting(this.lcc);
        if (this.compressIRGs.length > 0) {
            this.updateAllIndexes(l, this.dd);
        }
        long l2 = this.td.getHeapConglomerateId();
        ConglomerateDescriptor conglomerateDescriptor = this.td.getConglomerateDescriptor(l2);
        this.dd.updateConglomerateDescriptor(conglomerateDescriptor, l, this.tc);
        this.tc.dropConglomerate(l2);
        this.cleanUp();
    }

    private void truncateTable(Activation activation) throws StandardException {
        Object object;
        TupleDescriptor tupleDescriptor;
        Object object2;
        Properties properties = new Properties();
        this.lcc = activation.getLanguageConnectionContext();
        this.dd = this.lcc.getDataDictionary();
        this.dm = this.dd.getDependencyManager();
        this.tc = this.lcc.getTransactionExecute();
        this.activation = activation;
        ConstraintDescriptorList constraintDescriptorList = this.dd.getConstraintDescriptors(this.td);
        int n = 0;
        while (n < constraintDescriptorList.size()) {
            object2 = constraintDescriptorList.elementAt(n);
            if (object2 instanceof ReferencedKeyConstraintDescriptor && ((ReferencedKeyConstraintDescriptor)(tupleDescriptor = (ReferencedKeyConstraintDescriptor)object2)).hasNonSelfReferencingFK(1)) {
                throw StandardException.newException("XCL48.S", this.td.getName());
            }
            ++n;
        }
        GenericDescriptorList genericDescriptorList = this.dd.getTriggerDescriptors(this.td);
        object2 = genericDescriptorList.elements();
        while (object2.hasMoreElements()) {
            tupleDescriptor = (TriggerDescriptor)object2.nextElement();
            if (!((TriggerDescriptor)tupleDescriptor).listensForEvent(2) || !((TriggerDescriptor)tupleDescriptor).isEnabled()) continue;
            throw StandardException.newException("XCL49.S", this.td.getName(), (Object)((TriggerDescriptor)tupleDescriptor).getName());
        }
        ExecRow execRow = this.td.getEmptyExecRow(this.lcc.getContextManager());
        this.compressHeapCC = this.tc.openConglomerate(this.td.getHeapConglomerateId(), false, 4, 7, 5);
        this.dm.invalidateFor(this.td, 42, this.lcc);
        RowLocation rowLocation = this.compressHeapCC.newRowLocationTemplate();
        this.compressHeapCC.getInternalTablePropertySet(properties);
        this.compressHeapCC.close();
        this.compressHeapCC = null;
        long l = this.tc.createConglomerate("heap", execRow.getRowArray(), null, properties, 0);
        this.getAffectedIndexes(activation);
        if (this.numIndexes > 0) {
            this.indexRows = new ExecIndexRow[this.numIndexes];
            this.ordering = new ColumnOrdering[this.numIndexes][];
            int n2 = 0;
            while (n2 < this.numIndexes) {
                this.indexRows[n2] = this.compressIRGs[n2].getIndexRowTemplate();
                this.compressIRGs[n2].getIndexRow(execRow, rowLocation, this.indexRows[n2], null);
                int[] nArray = this.compressIRGs[n2].baseColumnPositions();
                object = this.compressIRGs[n2].isAscending();
                int n3 = nArray.length + 1;
                this.ordering[n2] = new ColumnOrdering[n3];
                int n4 = 0;
                while (n4 < n3 - 1) {
                    this.ordering[n2][n4] = new IndexColumnOrder(n4, (boolean)object[n4]);
                    ++n4;
                }
                this.ordering[n2][n3 - 1] = new IndexColumnOrder(n3 - 1);
                ++n2;
            }
        }
        this.dd.startWriting(this.lcc);
        if (this.numIndexes > 0) {
            long[] lArray = new long[this.numIndexes];
            int n5 = 0;
            while (n5 < this.numIndexes) {
                this.updateIndex(l, this.dd, n5, lArray);
                ++n5;
            }
        }
        long l2 = this.td.getHeapConglomerateId();
        object = this.td.getConglomerateDescriptor(l2);
        this.dd.updateConglomerateDescriptor((ConglomerateDescriptor)object, l, this.tc);
        this.tc.dropConglomerate(l2);
        this.cleanUp();
    }

    private void updateAllIndexes(long l, DataDictionary dataDictionary) throws StandardException {
        long[] lArray = new long[this.numIndexes];
        if (this.sequential) {
            if (this.numIndexes >= 1) {
                this.updateIndex(l, dataDictionary, 0, lArray);
            }
            int n = 1;
            while (n < this.numIndexes) {
                this.openBulkFetchScan(l);
                while (this.getNextRowFromRowSource() != null) {
                    this.objectifyStreamingColumns();
                    this.insertIntoSorter(n, this.compressRL[this.currentCompressRow - 1]);
                }
                this.updateIndex(l, dataDictionary, n, lArray);
                this.closeBulkFetchScan();
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.numIndexes) {
                this.updateIndex(l, dataDictionary, n, lArray);
                ++n;
            }
        }
    }

    private void updateIndex(long l, DataDictionary dataDictionary, int n, long[] lArray) throws StandardException {
        Properties properties = new Properties();
        ConglomerateDescriptor conglomerateDescriptor = this.td.getConglomerateDescriptor(this.indexConglomerateNumbers[n]);
        ConglomerateController conglomerateController = this.tc.openConglomerate(this.indexConglomerateNumbers[n], false, 4, 7, 5);
        conglomerateController.getInternalTablePropertySet(properties);
        int n2 = this.indexRows[n].nColumns();
        ((Hashtable)properties).put("baseConglomerateId", Long.toString(l));
        if (conglomerateDescriptor.getIndexDescriptor().isUnique()) {
            ((Hashtable)properties).put("nUniqueColumns", Integer.toString(n2 - 1));
        } else {
            ((Hashtable)properties).put("nUniqueColumns", Integer.toString(n2));
        }
        ((Hashtable)properties).put("rowLocationColumn", Integer.toString(n2 - 1));
        ((Hashtable)properties).put("nKeyFields", Integer.toString(n2));
        conglomerateController.close();
        RowLocationRetRowSource rowLocationRetRowSource = null;
        boolean bl = false;
        if (!this.truncateTable) {
            this.sorters[n].close();
            this.sorters[n] = null;
            if (this.td.statisticsExist(conglomerateDescriptor)) {
                rowLocationRetRowSource = new CardinalityCounter(this.tc.openSortRowSource(this.sortIds[n]));
                bl = true;
            } else {
                rowLocationRetRowSource = this.tc.openSortRowSource(this.sortIds[n]);
            }
            lArray[n] = this.tc.createAndLoadConglomerate("BTREE", this.indexRows[n].getRowArray(), this.ordering[n], properties, 0, rowLocationRetRowSource, null);
        } else {
            lArray[n] = this.tc.createConglomerate("BTREE", this.indexRows[n].getRowArray(), this.ordering[n], properties, 0);
            if (this.td.statisticsExist(conglomerateDescriptor)) {
                dataDictionary.dropStatisticsDescriptors(this.td.getUUID(), conglomerateDescriptor.getUUID(), this.tc);
            }
        }
        if (bl) {
            dataDictionary.dropStatisticsDescriptors(this.td.getUUID(), conglomerateDescriptor.getUUID(), this.tc);
            long l2 = ((CardinalityCounter)rowLocationRetRowSource).getRowCount();
            if (l2 > 0L) {
                long[] lArray2 = ((CardinalityCounter)rowLocationRetRowSource).getCardinality();
                int n3 = 0;
                while (n3 < lArray2.length) {
                    StatisticsDescriptor statisticsDescriptor = new StatisticsDescriptor(dataDictionary, dataDictionary.getUUIDFactory().createUUID(), conglomerateDescriptor.getUUID(), this.td.getUUID(), "I", new StatisticsImpl(l2, lArray2[n3]), n3 + 1);
                    dataDictionary.addDescriptor(statisticsDescriptor, null, 14, true, this.tc);
                    ++n3;
                }
            }
        }
        dataDictionary.updateConglomerateDescriptor(this.td.getConglomerateDescriptors(this.indexConglomerateNumbers[n]), lArray[n], this.tc);
        this.tc.dropConglomerate(this.indexConglomerateNumbers[n]);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void getAffectedIndexes(Activation var1_1) throws StandardException {
        block18: {
            var2_2 = this.td.getIndexLister();
            this.compressIRGs = var2_2.getIndexRowGenerators();
            this.numIndexes = this.compressIRGs.length;
            this.indexConglomerateNumbers = var2_2.getIndexConglomerateNumbers();
            if (this.compressTable || this.truncateTable) break block18;
            var3_3 = 0;
            while (var3_3 < this.compressIRGs.length) {
                var4_5 /* !! */  = this.compressIRGs[var3_3].baseColumnPositions();
                var5_7 = 0;
                while (var5_7 < var4_5 /* !! */ .length) {
                    if (var4_5 /* !! */ [var5_7] == this.columnPosition) break;
                    ++var5_7;
                }
                if (var5_7 != var4_5 /* !! */ .length) {
                    if (var4_5 /* !! */ .length == 1 || this.behavior == 0 && this.compressIRGs[var3_3].isUnique()) {
                        --this.numIndexes;
                        var6_10 = this.td.getConglomerateDescriptor(this.indexConglomerateNumbers[var3_3]);
                        DropIndexConstantAction.dropIndex(this.dm, this.dd, this.tc, var6_10, this.td, var1_1);
                        this.compressIRGs[var3_3] = null;
                    } else if (this.compressIRGs[var3_3].isUnique()) {
                        var6_10 = this.td.getConglomerateDescriptor(this.indexConglomerateNumbers[var3_3]);
                        throw StandardException.newException("X0Y25.S", this.dm.getActionString(37), (Object)this.columnInfo[0].name, (Object)"UNIQUE INDEX", (Object)var6_10.getConglomerateName());
                    }
                }
                ++var3_3;
            }
            var3_4 = new IndexRowGenerator[this.numIndexes];
            var4_5 /* !! */  = (int[])new long[this.numIndexes];
            var5_7 = 0;
            var6_11 = 0;
            ** GOTO lbl69
            {
                ++var6_11;
                do {
                    if (this.compressIRGs[var6_11] == null) continue block2;
                    var7_12 = this.compressIRGs[var6_11].baseColumnPositions();
                    var3_4[var5_7] = this.compressIRGs[var6_11];
                    var4_5 /* !! */ [var5_7] = (int)this.indexConglomerateNumbers[var6_11];
                    var8_13 = this.compressIRGs[var6_11].isAscending();
                    var9_14 = false;
                    var10_15 = var7_12.length;
                    var11_16 = 0;
                    while (var11_16 < var10_15) {
                        if (var7_12[var11_16] > this.columnPosition) {
                            v0 = var11_16;
                            var7_12[v0] = var7_12[v0] - 1;
                        } else if (var7_12[var11_16] == this.columnPosition) {
                            var7_12[var11_16] = 0;
                            var9_14 = true;
                        }
                        ++var11_16;
                    }
                    if (var9_14) {
                        var11_17 = new int[--var10_15];
                        var12_18 = new boolean[var10_15];
                        var13_20 = 0;
                        var14_21 = 0;
                        while (var13_20 < var10_15) {
                            if (var14_21 == 0 && var7_12[var13_20 + var14_21] == 0) {
                                ++var14_21;
                            }
                            var11_17[var13_20] = var7_12[var13_20 + var14_21];
                            var12_18[var13_20] = var8_13[var13_20 + var14_21];
                            ++var13_20;
                        }
                        var13_19 = this.compressIRGs[var6_11].getIndexDescriptor();
                        var13_19.setBaseColumnPositions(var11_17);
                        var13_19.setIsAscending(var12_18);
                        var13_19.setNumberOfOrderedColumns(var13_19.numberOfOrderedColumns() - 1);
                    }
                    ++var5_7;
                    ++var6_11;
lbl69:
                    // 2 sources

                } while (var5_7 < this.numIndexes);
            }
            this.compressIRGs = var3_4;
            this.indexConglomerateNumbers = var4_5 /* !! */ ;
        }
        if ((var3_4 = this.compressIndexArrays(this.indexConglomerateNumbers, this.compressIRGs)) != null) {
            this.indexConglomerateNumbers = (long[])var3_4[1];
            this.compressIRGs = (IndexRowGenerator[])var3_4[2];
            this.numIndexes = this.indexConglomerateNumbers.length;
        }
        this.indexedCols = new FormatableBitSet(this.compressTable != false || this.truncateTable != false ? this.td.getNumberOfColumns() + 1 : this.td.getNumberOfColumns());
        var4_6 = 0;
        while (var4_6 < this.numIndexes) {
            var5_9 = this.compressIRGs[var4_6].getIndexDescriptor().baseColumnPositions();
            var6_11 = 0;
            while (var6_11 < var5_9.length) {
                this.indexedCols.set(var5_9[var6_11]);
                ++var6_11;
            }
            ++var4_6;
        }
    }

    private void setUpAllSorts(ExecRow execRow, RowLocation rowLocation) throws StandardException {
        this.ordering = new ColumnOrdering[this.numIndexes][];
        this.needToDropSort = new boolean[this.numIndexes];
        this.sortIds = new long[this.numIndexes];
        int n = 0;
        while (n < this.numIndexes) {
            this.indexRows[n] = this.compressIRGs[n].getIndexRowTemplate();
            this.compressIRGs[n].getIndexRow(execRow, rowLocation, this.indexRows[n], null);
            int[] nArray = this.compressIRGs[n].baseColumnPositions();
            boolean[] blArray = this.compressIRGs[n].isAscending();
            BasicSortObserver basicSortObserver = null;
            boolean bl = this.numIndexes == 1;
            int n2 = nArray.length + 1;
            basicSortObserver = new BasicSortObserver(false, false, this.indexRows[n], bl);
            this.ordering[n] = new ColumnOrdering[n2];
            int n3 = 0;
            while (n3 < n2 - 1) {
                this.ordering[n][n3] = new IndexColumnOrder(n3, blArray[n3]);
                ++n3;
            }
            this.ordering[n][n2 - 1] = new IndexColumnOrder(n2 - 1);
            this.sortIds[n] = this.tc.createSort(null, this.indexRows[n].getRowArrayClone(), this.ordering[n], basicSortObserver, false, this.estimatedRowCount, -1);
            ++n;
        }
        this.sorters = new SortController[this.numIndexes];
        n = 0;
        while (n < this.numIndexes) {
            this.sorters[n] = this.tc.openSort(this.sortIds[n]);
            this.needToDropSort[n] = true;
            ++n;
        }
    }

    public FormatableBitSet getValidColumns() {
        return null;
    }

    public DataValueDescriptor[] getNextRowFromRowSource() throws StandardException {
        int n;
        this.currentRow = null;
        if (!(this.doneScan || this.currentCompressRow != this.bulkFetchSize && this.validRow[this.currentCompressRow])) {
            n = 0;
            n = this.compressHeapGSC.fetchNextGroup(this.baseRowArray, this.compressRL);
            this.doneScan = n != this.bulkFetchSize;
            this.currentCompressRow = 0;
            this.rowCount += n;
            int n2 = 0;
            while (n2 < n) {
                this.validRow[n2] = true;
                ++n2;
            }
            n2 = n;
            while (n2 < this.bulkFetchSize) {
                this.validRow[n2] = false;
                ++n2;
            }
        }
        if (this.validRow[this.currentCompressRow]) {
            if (this.compressTable) {
                this.currentRow = this.baseRow[this.currentCompressRow];
            } else {
                if (this.currentRow == null) {
                    this.currentRow = this.activation.getExecutionFactory().getValueRow(this.baseRowArray[this.currentCompressRow].length - 1);
                }
                n = 0;
                while (n < this.currentRow.nColumns()) {
                    this.currentRow.setColumn(n + 1, n < this.columnPosition - 1 ? this.baseRow[this.currentCompressRow].getColumn(n + 1) : this.baseRow[this.currentCompressRow].getColumn(n + 1 + 1));
                    ++n;
                }
            }
            ++this.currentCompressRow;
        }
        if (this.currentRow != null) {
            if (this.compressIRGs.length > 0) {
                this.currentRow = this.currentRow.getClone(this.indexedCols);
            }
            return this.currentRow.getRowArray();
        }
        return null;
    }

    public boolean needsToClone() {
        return true;
    }

    public void closeRowSource() {
    }

    public boolean needsRowLocation() {
        return this.numIndexes > 0;
    }

    public void rowLocation(RowLocation rowLocation) throws StandardException {
        if (this.compressIRGs.length > 0) {
            this.objectifyStreamingColumns();
            int n = this.compressIRGs.length;
            if (n > 1 && this.sequential) {
                n = 1;
            }
            int n2 = 0;
            while (n2 < n) {
                this.insertIntoSorter(n2, rowLocation);
                ++n2;
            }
        }
    }

    private void objectifyStreamingColumns() throws StandardException {
        int n = 0;
        while (n < this.currentRow.getRowArray().length) {
            if (this.indexedCols.get(n + 1) && this.currentRow.getRowArray()[n] instanceof StreamStorable) {
                this.currentRow.getRowArray()[n].getObject();
            }
            ++n;
        }
    }

    private void insertIntoSorter(int n, RowLocation rowLocation) throws StandardException {
        this.indexRows[n].getNewObjectArray();
        this.compressIRGs[n].getIndexRow(this.currentRow, (RowLocation)rowLocation.cloneObject(), this.indexRows[n], null);
        this.sorters[n].insert(this.indexRows[n].getRowArray());
    }

    public void cleanUp() throws StandardException {
        int n;
        if (this.compressHeapCC != null) {
            this.compressHeapCC.close();
            this.compressHeapCC = null;
        }
        if (this.compressHeapGSC != null) {
            this.closeBulkFetchScan();
        }
        if (this.sorters != null) {
            n = 0;
            while (n < this.compressIRGs.length) {
                if (this.sorters[n] != null) {
                    this.sorters[n].close();
                }
                this.sorters[n] = null;
                ++n;
            }
        }
        if (this.needToDropSort != null) {
            n = 0;
            while (n < this.needToDropSort.length) {
                if (this.needToDropSort[n]) {
                    this.tc.dropSort(this.sortIds[n]);
                    this.needToDropSort[n] = false;
                }
                ++n;
            }
        }
    }

    private int getSemiRowCount(TransactionController transactionController) throws StandardException {
        int n = 0;
        ScanController scanController = transactionController.openScan(this.td.getHeapConglomerateId(), false, 0, 7, 5, RowUtil.EMPTY_ROW_BITSET, null, 1, null, null, -1);
        while (scanController.next()) {
            if (++n == 2) break;
        }
        scanController.close();
        return n;
    }

    private void updateNewColumnToDefault(Activation activation, String string, String string2, LanguageConnectionContext languageConnectionContext) throws StandardException {
        String string3 = "UPDATE \"" + this.td.getSchemaName() + "\".\"" + this.td.getName() + "\" SET \"" + string + "\" = " + string2;
        AlterTableConstantAction.executeUpdate(languageConnectionContext, string3);
    }

    private static void executeUpdate(LanguageConnectionContext languageConnectionContext, String string) throws StandardException {
        PreparedStatement preparedStatement = languageConnectionContext.prepareInternalStatement(string);
        ResultSet resultSet = preparedStatement.execute(languageConnectionContext, true);
        resultSet.close();
        resultSet.finish();
    }

    private long getColumnMax(Activation activation, TableDescriptor tableDescriptor, String string, long l, long l2) throws StandardException {
        String string2 = l > 0L ? "MAX" : "MIN";
        String string3 = "SELECT " + string2 + "(\"" + string + "\")" + "FROM \"" + tableDescriptor.getSchemaName() + "\".\"" + tableDescriptor.getName() + "\"";
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        PreparedStatement preparedStatement = languageConnectionContext.prepareInternalStatement(string3);
        ResultSet resultSet = preparedStatement.execute(languageConnectionContext, false);
        DataValueDescriptor[] dataValueDescriptorArray = resultSet.getNextRow().getRowArray();
        resultSet.close();
        resultSet.finish();
        return dataValueDescriptorArray[0].getLong();
    }

    private void dropAllColumnDefaults(UUID uUID, DataDictionary dataDictionary) throws StandardException {
        ColumnDescriptorList columnDescriptorList = this.td.getColumnDescriptorList();
        int n = columnDescriptorList.size();
        int n2 = 0;
        while (n2 < n) {
            ColumnDescriptor columnDescriptor = columnDescriptorList.elementAt(n2);
            if (columnDescriptor.getDefaultInfo() != null) {
                DefaultDescriptor defaultDescriptor = columnDescriptor.getDefaultDescriptor(dataDictionary);
                this.dm.clearDependencies(this.lcc, defaultDescriptor);
            }
            ++n2;
        }
    }

    private void openBulkFetchScan(long l) throws StandardException {
        this.doneScan = false;
        this.compressHeapGSC = this.tc.openGroupFetchScan(l, false, 0, 7, 5, null, null, 0, null, null, 0);
    }

    private void closeBulkFetchScan() throws StandardException {
        this.compressHeapGSC.close();
        this.compressHeapGSC = null;
    }

    private void updateNewAutoincrementColumn(Activation activation, String string, long l, long l2) throws StandardException {
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        languageConnectionContext.setAutoincrementUpdate(true);
        languageConnectionContext.autoincrementCreateCounter(this.td.getSchemaName(), this.td.getName(), string, new Long(l), l2, 0);
        String string2 = "UPDATE \"" + this.td.getSchemaName() + "\".\"" + this.td.getName() + "\" SET \"" + string + "\" = " + "org.apache.derby.iapi.db.ConnectionInfo::" + "nextAutoincrementValue(" + "'" + this.td.getSchemaName() + "'" + "," + "'" + this.td.getName() + "'" + "," + "'" + string + "'" + ")";
        try {
            try {
                AlterTableConstantAction.executeUpdate(languageConnectionContext, string2);
            }
            catch (StandardException standardException) {
                if (standardException.getMessageId().equals("22003")) {
                    throw StandardException.newException("42Z24", standardException, (Object)this.td.getName(), (Object)string);
                }
                throw standardException;
            }
            Object var10_7 = null;
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            languageConnectionContext.autoincrementFlushCache(this.td.getUUID());
            languageConnectionContext.setAutoincrementUpdate(false);
            throw throwable;
        }
        languageConnectionContext.autoincrementFlushCache(this.td.getUUID());
        languageConnectionContext.setAutoincrementUpdate(false);
    }

    private boolean validateNotNullConstraint(String[] stringArray, boolean[] blArray, int n, LanguageConnectionContext languageConnectionContext, String string) throws StandardException {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < stringArray.length) {
            ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(stringArray[n2]);
            if (columnDescriptor == null) {
                throw StandardException.newException("42X14", stringArray[n2], (Object)this.td.getName());
            }
            if (columnDescriptor.getType().isNullable()) {
                if (n > 0) {
                    if (bl) {
                        stringBuffer.append(" AND ");
                    }
                    stringBuffer.append(stringArray[n2] + " IS NOT NULL ");
                }
                bl = true;
                blArray[n2] = true;
            }
            ++n2;
        }
        if (bl && n > 0 && !ConstraintConstantAction.validateConstraint(null, stringBuffer.toString(), this.td, languageConnectionContext, false)) {
            if (string.equals("X0Y63.S")) {
                throw StandardException.newException("X0Y63.S", this.td.getQualifiedName());
            }
            throw StandardException.newException("X0Y80.S", this.td.getQualifiedName(), (Object)stringArray[0]);
        }
        return bl;
    }

    private Object[] compressIndexArrays(long[] lArray, IndexRowGenerator[] indexRowGeneratorArray) {
        long[] lArray2 = new long[lArray.length];
        int n = 0;
        int n2 = lArray.length - 1;
        int n3 = 0;
        while (n3 < lArray.length) {
            int n4 = 0;
            while (n4 < n) {
                if (lArray[n3] == lArray2[n4]) {
                    lArray2[n2--] = n3;
                    break;
                }
                ++n4;
            }
            if (n4 == n) {
                lArray2[n++] = lArray[n3];
            }
            ++n3;
        }
        if (n < lArray.length) {
            long[] lArray3 = new long[n];
            IndexRowGenerator[] indexRowGeneratorArray2 = new IndexRowGenerator[n];
            int[] nArray = new int[lArray.length - n];
            n2 = 0;
            int n5 = 0;
            int n6 = lArray.length - 1;
            while (n5 < lArray.length) {
                if (n5 < n) {
                    lArray3[n5] = lArray2[n5];
                } else {
                    nArray[lArray.length - n5 - 1] = (int)lArray2[n5];
                }
                if (n6 >= n && n5 == (int)lArray2[n6]) {
                    --n6;
                } else {
                    indexRowGeneratorArray2[n2] = indexRowGeneratorArray[n5];
                    ++n2;
                }
                ++n5;
            }
            Object[] objectArray = new Object[]{nArray, lArray3, indexRowGeneratorArray2};
            return objectArray;
        }
        return null;
    }

    AlterTableConstantAction(SchemaDescriptor schemaDescriptor, String string, UUID uUID, long l, int n, ColumnInfo[] columnInfoArray, ConstraintConstantAction[] constraintConstantActionArray, char c, boolean bl, int n2, boolean bl2, boolean bl3) {
        super(uUID);
        this.sd = schemaDescriptor;
        this.tableName = string;
        this.tableConglomerateId = l;
        this.tableType = n;
        this.columnInfo = columnInfoArray;
        this.constraintActions = constraintConstantActionArray;
        this.lockGranularity = c;
        this.compressTable = bl;
        this.behavior = n2;
        this.sequential = bl2;
        this.truncateTable = bl3;
    }
}

